/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.integration.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbquests.integration.jei.JEIRecipeTypes;
import dev.ftb.mods.ftbquests.integration.jei.WrappedQuest;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class QuestCategory
implements IRecipeCategory<WrappedQuest> {
    public static final ResourceLocation UID = new ResourceLocation("ftbquests", "quest");
    public static final ResourceLocation TEXTURE = new ResourceLocation("ftbquests:textures/gui/jei/quest.png");
    private final IDrawable background;
    private final IDrawable icon;

    public QuestCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 144, 74);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)FTBQuestsItems.BOOK.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<WrappedQuest> getRecipeClass() {
        return WrappedQuest.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("ftbquests.quests");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<WrappedQuest> getRecipeType() {
        return JEIRecipeTypes.QUEST;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WrappedQuest recipe, IFocusGroup focuses) {
        int inputSize = Math.min(9, recipe.input.size());
        for (int i = 0; i < inputSize; ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, i % 3 * 18 + 1, i / 3 * 18 + 21).addItemStacks(recipe.input.get(i));
        }
        int outputSize = Math.min(9, recipe.output.size());
        for (int i = 0; i < outputSize; ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, i % 3 * 18 + 90 + 1, i / 3 * 18 + 21).addItemStacks(recipe.output.get(i));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void draw(WrappedQuest recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        text = recipe.quest.getTitle().m_6881_().m_130940_(ChatFormatting.UNDERLINE);
        font = Minecraft.m_91087_().f_91062_;
        w = font.m_92852_((FormattedText)text);
        x = (float)(this.background.getWidth() - w) / 2.0f;
        y = 3.0f;
        if (!(mouseX >= (double)x) || !(mouseY >= (double)y) || !(mouseX < (double)(x + (float)w))) ** GOTO lbl-1000
        Objects.requireNonNull(font);
        if (mouseY < (double)(y + 9.0f)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        highlight = v0;
        font.m_92889_(stack, (Component)text, x, y, highlight != false ? -5735842 : -12636637);
    }

    public boolean handleInput(WrappedQuest recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && mouseY >= 0.0 && mouseY < 20.0) {
            recipe.openQuestGui();
            return true;
        }
        return false;
    }
}

